//
//  IFWebViewController.m
//  PDFReader
//
//  Created by hxhg-LiDong on 12-12-12.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "IFWebViewController.h"
#import "FSFileItem.h"
#import <WebKit/WebKit.h>

@interface IFWebViewController ()

@end

@implementation IFWebViewController

- (id)initWithFileItem:(FSFileItem *)fileItem {
    if (self = [super init]) {
        _fileItem = fileItem;
        
        [self setTitle:[_fileItem displayName]];
        
        _statusBarStyle = UIStatusBarStyleLightContent;
        
        UIBarButtonItem *stopItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemStop target:self action:@selector(onClose)];
        
        [[self navigationItem] setLeftBarButtonItem:stopItem];
        UIBarButtonItem *fullScreenItem = [[UIBarButtonItem alloc] initWithImage:[UIImage imageNamed:@"bar/fullscreen.png"] style:UIBarButtonItemStylePlain target:self action:@selector(onFullScreen)];
        UIBarButtonItem *flexibleItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:nil action:NULL];
        NSArray *toolbarItems = [[NSArray alloc] initWithObjects:fullScreenItem, flexibleItem, _rotationItem, nil];
        
        [self setToolbarItems:toolbarItems];
        
        }
    return self;
}

- (void)loadView {
    _contentView = [[WKWebView alloc] initWithFrame:CGRectPortraitScreen];
    [_contentView setUIDelegate:self];
    [_contentView setBackgroundColor:UIColorTexturedBackground];
    
    _floatButton = [[UIButton alloc] initWithFrame:CGRectZero];
    [_floatButton setImageEdgeInsets:UIEdgeInsetsMake(4, 4, 4, 4)];
    [_floatButton setImage:[UIImage imageNamed:@"wb/fullscreen_exit.png"] forState:UIControlStateNormal];
    [_floatButton addTarget:self action:@selector(onExitFullScreen) forControlEvents:UIControlEventTouchUpInside];
    [_floatButton setAlpha:0.f];
    [_contentView addSubview:_floatButton];
    
    NSURL *url = [[NSURL alloc] initFileURLWithPath:[_fileItem path]];
    NSURLRequest *request = [[NSURLRequest alloc] initWithURL:url cachePolicy:NSURLRequestReloadIgnoringCacheData timeoutInterval:30];
    
    [_contentView loadRequest:request];
    [self setView:_contentView];
}

- (void)releaseSubviews {
    _contentView = nil;
    _floatButton = nil;
}

- (void)dealloc {
}

- (void)layoutWithContentSize:(const CGSize)contentSize {
    const CGRect buttonFrame = { contentSize.width - 37, contentSize.height - 37, 32, 32 };
    
    [_floatButton setFrame:buttonFrame];
}

#pragma mark - Action

- (void)setFloatButtonAlpha:(CGFloat)alpha {
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:0.3];
    [_floatButton setAlpha:alpha];
    [UIView commitAnimations];
}

- (void)onFullScreen {
    [self setFullScreen:YES];
    [self setFloatButtonAlpha:1.f];
}

- (void)onExitFullScreen {
    [self setFullScreen:NO];
    [self setFloatButtonAlpha:0.f];
}

- (void)onClose {
    [[self navigationController] dismissViewControllerAnimated:YES completion:NULL];
}

@end
